/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.launcher;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.BusyException;
import com.teacode.update2.common.Locker;
import com.teacode.update2.common.Resources;
import com.teacode.update2.common.RunData;
import com.teacode.update2.common.Text;
import com.teacode.update2.common.ui.ConsoleDisplay;
import com.teacode.update2.common.ui.GUIDisplay;
import com.teacode.update2.launcher.TempWorker;
import com.teacode.update2.updater.UpdateWorker;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class LauncherWorker {
    public static Map<String, String> jars = new HashMap<String, String>();
    public static String updateName = null;
    public static ApplicationData currentApplication = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<URL> prepareJarURLs(ApplicationData app, RunData runData) {
        boolean repeat = false;
        do {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                try (Locker locker = new Locker(app, false);){
                    Resources resources = Resources.getLast(app);
                    updateName = resources.getUpdateName();
                    TempWorker temp = TempWorker.create(app);
                    List<String> files = resources.getUpdateTxt(true);
                    if (files == null) {
                        throw new IllegalStateException(String.format(Text.text("launcher.not.found"), "update.txt"));
                    }
                    for (String file : files) {
                        File f = resources.getFile(file);
                        if (f == null) {
                            throw new IllegalStateException(String.format(Text.text("launcher.not.found"), file));
                        }
                        File jar = temp.createJar(f, resources.getCRC(file));
                        jars.put(file, jar.getAbsolutePath());
                        urls.add(jar.toURI().toURL());
                    }
                }
                return urls;
            }
            catch (BusyException e) {
                app.display.showLauncherError(e.getMessage() + "\n\n" + Text.text("launcher.try.wait"));
                System.exit(2);
            }
            catch (Exception e) {
                System.out.println("Launcher error: " + e);
                e.printStackTrace(System.out);
                if (!runData.updateOnError) continue;
                ApplicationData consoleApp = app.copy(ConsoleDisplay.instance);
                repeat = UpdateWorker.update(consoleApp, false);
            }
            catch (Throwable tr) {
                app.display.showLauncherError(tr.getMessage());
                System.exit(3);
            }
        } while (repeat);
        return null;
    }

    public static void launch(final ApplicationData app, RunData runData, final String[] args) {
        if (app == null) {
            System.exit(1);
        }
        String uri = app.updateURL;
        final String mainClass = runData.mainClass;
        final List<URL> urls = LauncherWorker.prepareJarURLs(app, runData);
        if (urls != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
                        Thread.currentThread().setContextClassLoader(classLoader);
                        Class<?> cl = classLoader.loadClass(mainClass);
                        Method m = cl.getMethod("main", String[].class);
                        Object[] param = new Object[]{args};
                        currentApplication = app;
                        m.invoke(null, param);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
            app.display.showSplash(String.format(Text.text("launcher.splash"), uri));
            if (app.display instanceof GUIDisplay) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

