/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.common;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.FileUtil;
import com.teacode.update2.common.Text;
import com.teacode.update2.updater.LoadListener;
import com.teacode.update2.updater.PercentInputStream;
import com.teacode.update2.updater.UpdateStatus;
import com.teacode.update2.updater.ui.DefaultLoadListener;
import com.teacode.update2.updater.ui.ProcessListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Resources {
    ApplicationData app;
    private final File dir;
    private static final String UPDATE_TXT = "update.txt";
    private static final String CHARSET = "UTF-8";
    private static final String UPDATE_PREFIX = "update";
    private static final DateFormat dateFormat = new SimpleDateFormat("--yyyy-MM-dd--HH-mm-ss");
    private static final int UPDATES_COUNT = 5;

    private Resources(ApplicationData app, File dir) {
        this.app = app;
        this.dir = dir;
    }

    public String getUpdateName() {
        return this.dir.getName();
    }

    public static String[] sortedUpdates(File appDir) {
        String[] updateNames = appDir.list();
        if (updateNames == null) {
            throw new RuntimeException(appDir + " is not directory (list failed)");
        }
        return (String[])Arrays.stream(updateNames).filter(n -> new File(appDir, (String)n).isDirectory() && n.startsWith(UPDATE_PREFIX)).sorted().toArray(String[]::new);
    }

    public static Resources getNew(ApplicationData app) {
        String n;
        File dir;
        File appDir = app.updateDir;
        String[] updateNames = Resources.sortedUpdates(appDir);
        int size = updateNames.length;
        if (size > 5) {
            int remove = size - 5;
            for (int i = 0; i < remove; ++i) {
                new Resources(app, new File(appDir, updateNames[i])).cleanUp();
            }
        }
        while ((dir = new File(appDir, n = UPDATE_PREFIX + dateFormat.format(new Date()))).exists() || !dir.mkdir()) {
        }
        return new Resources(app, dir);
    }

    public static Resources getLast(ApplicationData app) {
        File appDir = app.updateDir;
        String[] updateNames = Resources.sortedUpdates(appDir);
        int size = updateNames.length;
        if (size > 0) {
            return new Resources(app, new File(appDir, updateNames[size - 1]));
        }
        return Resources.getNew(app);
    }

    private File dataFile(String name) {
        return new File(this.dir, name + ".data");
    }

    private File etagFile(String name) {
        return new File(this.dir, name + ".etag");
    }

    private File crcFile(String name) {
        return new File(this.dir, name + ".crc");
    }

    public File getFile(String fileName) {
        File file = this.dataFile(fileName);
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    private String getTextFile(File file) {
        if (file.exists() && file.isFile()) {
            try {
                return FileUtil.readFully(file, CHARSET);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getEtagWithChecking(String fileName) {
        if (!this.isLocalCorrect(fileName)) {
            return null;
        }
        File file = this.etagFile(fileName);
        return this.getTextFile(file);
    }

    public Long getCRC(String fileName) {
        File file = this.crcFile(fileName);
        String text = this.getTextFile(file);
        if (text != null) {
            try {
                return Long.parseLong(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void saveEtag(String filename, String etag) throws IOException {
        FileUtil.saveTextFile(this.etagFile(filename), etag);
    }

    public void saveCRC(String filename, String crc) throws IOException {
        FileUtil.saveTextFile(this.crcFile(filename), crc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getUpdateTxt(boolean localOnly) {
        if (localOnly) {
            if (!this.isLocalCorrect(UPDATE_TXT)) {
                return null;
            }
            File f = this.getFile(UPDATE_TXT);
            if (f != null) return FileUtil.splitLines(f, CHARSET);
            return null;
        }
        try {
            String uri = this.app.updateURL;
            try (InputStream in = new URL(uri + UPDATE_TXT).openStream();){
                List<String> list = FileUtil.splitLines(in, CHARSET);
                return list;
            }
        }
        catch (Throwable e) {
            return null;
        }
    }

    private boolean isLocalCorrect(String fileName) {
        File file = this.getFile(fileName);
        if (file == null) {
            return false;
        }
        Long crc = this.getCRC(fileName);
        return crc != null && FileUtil.verifyCRC(file, crc);
    }

    public Integer getUpdatedResourceSize(String filename) throws IOException {
        String uri = this.app.updateURL;
        String u = uri + filename;
        HttpURLConnection con = (HttpURLConnection)new URL(u).openConnection();
        try {
            String oldEtag = this.getEtagWithChecking(filename);
            if (oldEtag != null) {
                con.setRequestProperty("If-None-Match", oldEtag);
                if (con.getResponseCode() == 304 || oldEtag.equals(con.getHeaderField("ETag"))) {
                    Integer n = null;
                    return n;
                }
                Integer n = con.getContentLength();
                return n;
            }
            if (con.getResponseCode() == 200) {
                Integer n = con.getContentLength();
                return n;
            }
            throw new IOException(con.getResponseMessage());
        }
        finally {
            con.disconnect();
        }
    }

    private void copyFromPrevious(Resources prevResources, String name, String etag) throws IOException {
        long crc = FileUtil.copyFileCRC(prevResources.dataFile(name), this.dataFile(name));
        this.saveCRC(name, String.valueOf(crc));
        this.saveEtag(name, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Resources prevResources, String name, LoadListener listener) throws IOException {
        String uri = this.app.updateURL;
        String u = uri + name;
        HttpURLConnection con = (HttpURLConnection)new URL(u).openConnection();
        try {
            String oldEtag = prevResources.getEtagWithChecking(name);
            if (oldEtag != null) {
                con.setRequestProperty("If-None-Match", oldEtag);
                if (con.getResponseCode() == 304) {
                    this.copyFromPrevious(prevResources, name, oldEtag);
                    return;
                }
            }
            String etag = con.getHeaderField("ETag");
            if (oldEtag != null && oldEtag.equals(etag)) {
                this.copyFromPrevious(prevResources, name, oldEtag);
                return;
            }
            int size = con.getContentLength();
            if (size != -1) {
                listener.setLength(size);
            }
            this.saveEtag(name, null);
            this.saveCRC(name, "none");
            File file = this.dataFile(name);
            try {
                PercentInputStream in = new PercentInputStream(con.getInputStream(), size, listener);
                try (FileOutputStream fout = new FileOutputStream(file);){
                    int read;
                    byte[] buffer = new byte[10240];
                    while ((read = in.read(buffer)) != -1) {
                        fout.write(buffer, 0, read);
                    }
                }
                this.saveEtag(name, etag);
                this.saveCRC(name, String.valueOf(FileUtil.crc(file)));
            }
            catch (IOException e) {
                file.delete();
                throw e;
            }
        }
        finally {
            con.disconnect();
        }
    }

    public boolean analyzeLocal() {
        List<String> lines = this.getUpdateTxt(true);
        if (lines == null) {
            return false;
        }
        for (String line : lines) {
            if (this.isLocalCorrect(line)) continue;
            return false;
        }
        return true;
    }

    public UpdateStatus analyzeUpdate() {
        List<String> lines = this.getUpdateTxt(false);
        if (lines == null) {
            return new UpdateStatus(false, String.format(Text.text("updater.update.broken"), UPDATE_TXT), String.format(Text.text("updater.update.brokenHTML"), UPDATE_TXT));
        }
        lines.add(0, UPDATE_TXT);
        int size = 0;
        boolean moreThan = false;
        for (String line : lines) {
            try {
                Integer s = this.getUpdatedResourceSize(line);
                if (s == null) continue;
                if (s == -1) {
                    moreThan = true;
                    continue;
                }
                size += s.intValue();
            }
            catch (IOException e) {
                return new UpdateStatus(false, String.format(Text.text("updater.update.broken"), line), String.format(Text.text("updater.update.brokenHTML"), line));
            }
        }
        if (size == 0) {
            if (moreThan) {
                return new UpdateStatus(true, Text.text("updater.update.ready.size.unknown"), Text.text("updater.update.ready.size.unknown"));
            }
            return new UpdateStatus(false, Text.text("updater.update.ok"), Text.text("updater.update.okHTML"));
        }
        if (moreThan) {
            return new UpdateStatus(true, String.format(Text.text("updater.update.ready.size.more"), Text.sizeText(size)), String.format(Text.text("updater.update.ready.size.more"), Text.sizeText(size)));
        }
        return new UpdateStatus(true, String.format(Text.text("updater.update.ready.size.about"), Text.sizeText(size)), String.format(Text.text("updater.update.ready.size.about"), Text.sizeText(size)));
    }

    public void updateAll(ProcessListener listener) throws IOException {
        listener.nextFile(UPDATE_TXT);
        DefaultLoadListener loadListener = new DefaultLoadListener(listener);
        Resources newResources = Resources.getNew(this.app);
        try {
            newResources.update(this, UPDATE_TXT, loadListener);
            List<String> files = newResources.getUpdateTxt(true);
            if (files == null) {
                throw new IllegalStateException(Text.text("updater.error.title") + ": " + UPDATE_TXT);
            }
            int size = files.size();
            int index = 1;
            for (String file : files) {
                String action = String.valueOf(index) + '/' + size + ' ' + file;
                listener.nextFile(action);
                loadListener = new DefaultLoadListener(listener);
                newResources.update(this, file, loadListener);
                ++index;
            }
        }
        catch (IOException e) {
            newResources.cleanUp();
            throw e;
        }
    }

    public void cleanUp() {
        try {
            File[] files = this.dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.delete()) continue;
                    f.deleteOnExit();
                }
            }
            if (!this.dir.delete()) {
                this.dir.deleteOnExit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

