/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.updater.ui;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.Resources;
import com.teacode.update2.common.Text;
import com.teacode.update2.common.ui.GUIDisplay;
import com.teacode.update2.updater.UpdateStatus;
import com.teacode.update2.updater.ui.CardPanel;
import com.teacode.update2.updater.ui.ProcessListener;
import com.teacode.update2.updater.ui.ProgressWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public abstract class UpdaterPanel
extends JPanel {
    private final ApplicationData app;
    private final JLabel text;
    private final JButton updateButton;
    private final JProgressBar bar;
    private final CardPanel cardPanel;
    private static final String TO_VERIFY = Text.text("updater.update.verifying");
    private static final String BAR_CARD = "bar";
    private static final String UPDATE_CARD = "updateButton";
    private static final String CLOSE_CARD = "closeButton";

    public abstract void onClose();

    public abstract void onRefresh();

    public UpdaterPanel(final ApplicationData app, final Window parent) {
        super(new BorderLayout());
        this.app = app;
        this.text = new JLabel();
        Font font = this.text.getFont();
        this.text.setFont(font.deriveFont(0, font.getSize2D() * 1.2f));
        this.text.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.text.setBackground(Color.WHITE);
        this.text.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.add((Component)this.text, "Center");
        this.bar = new JProgressBar();
        JButton closeButton = new JButton(Text.text("updater.button.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdaterPanel.this.onClose();
            }
        });
        this.updateButton = new JButton(Text.text("updater.update"));
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdaterPanel.this.updateButton.setEnabled(false);
                final String url = app.updateURL;
                new ProgressWorker<Void>(parent, String.format(Text.text("updater.title"), url), String.format(Text.text("updater.action"), url)){

                    @Override
                    protected Void doWork() throws Exception {
                        ProcessListener processListener = new ProcessListener(){
                            String action = "";

                            @Override
                            public void nextFile(String action) {
                                this.action = action;
                                this.setAction(action, null);
                            }

                            @Override
                            public void knownSize(String size) {
                                this.action = this.action + " " + size;
                                this.setAction(this.action, null);
                            }

                            @Override
                            public void loadingPercent(int percent) {
                                this.setAction(this.action, percent);
                            }
                        };
                        Resources r = Resources.getLast(app);
                        r.updateAll(processListener);
                        return null;
                    }

                    @Override
                    protected void doneWork(Void result) {
                        JOptionPane.showMessageDialog(parent, Text.text("updater.done"), String.format(Text.text("updater.title"), url), 1);
                        UpdaterPanel.this.onClose();
                    }

                    @Override
                    protected void terminatedWork(Exception e) {
                        GUIDisplay.instance.showUpdateError(parent, e);
                        UpdaterPanel.this.refreshStatus();
                    }
                }.start();
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.updateButton, "Center");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        closeButtonPanel.add((Component)closeButton, "Center");
        closeButtonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.cardPanel = new CardPanel();
        this.cardPanel.add(BAR_CARD, this.bar);
        this.cardPanel.add(UPDATE_CARD, buttonPanel);
        this.cardPanel.add(CLOSE_CARD, closeButtonPanel);
        this.add((Component)this.cardPanel, "Last");
        this.refreshStatus();
    }

    private void refreshStatus() {
        final Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.cardPanel.select(BAR_CARD);
        this.bar.setMaximum(100);
        this.bar.setIndeterminate(true);
        this.bar.setStringPainted(true);
        this.bar.setString(TO_VERIFY);
        this.updateButton.setEnabled(false);
        this.setText(TO_VERIFY, TO_VERIFY);
        new SwingWorker<String[], String[]>(){
            private boolean local;
            private UpdateStatus update;

            @Override
            protected String[] doInBackground() {
                Resources r = Resources.getLast(UpdaterPanel.this.app);
                String[] ret = new String[]{TO_VERIFY, TO_VERIFY};
                this.local = r.analyzeLocal();
                ret[0] = Text.text(this.local ? "updater.local.readyHTML" : "updater.local.brokenHTML");
                this.publish((V[])new String[][]{ret});
                this.update = r.analyzeUpdate();
                ret[1] = this.update.getMessageHTML();
                return ret;
            }

            @Override
            protected void process(List<String[]> chunks) {
                if (!chunks.isEmpty()) {
                    UpdaterPanel.this.setText(chunks.get(chunks.size() - 1));
                }
            }

            @Override
            protected void done() {
                try {
                    UpdaterPanel.this.setText((String[])this.get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                UpdaterPanel.this.setCursor(oldCursor);
                UpdaterPanel.this.bar.setIndeterminate(false);
                UpdaterPanel.this.bar.setValue(100);
                UpdaterPanel.this.bar.setString(null);
                UpdaterPanel.this.updateButton.setText(Text.text(this.local ? "updater.update" : "updater.install"));
                UpdaterPanel.this.updateButton.setEnabled(this.update.isUpdateAvailable());
                UpdaterPanel.this.cardPanel.select(this.update.isUpdateAvailable() ? UpdaterPanel.UPDATE_CARD : UpdaterPanel.CLOSE_CARD);
            }
        }.execute();
    }

    private void setText(String[] s) {
        this.setText(s[0], s[1]);
    }

    private void setText(String localInfo, String updateInfo) {
        this.text.setText("<html><p>" + String.format(Text.text("updater.application"), this.app.updateURL) + "</p><p>" + Text.text("updater.local.version") + " " + localInfo + "</p><p>" + Text.text("updater.update.version") + " " + updateInfo + "</p></html>");
        this.onRefresh();
    }
}

