/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.updater;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.Locker;
import com.teacode.update2.common.Resources;
import com.teacode.update2.common.Text;
import com.teacode.update2.updater.UpdateStatus;
import com.teacode.update2.updater.ui.ProcessListener;
import java.io.IOException;
import java.util.stream.IntStream;

public class UpdateConsole {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(Locker locker, ApplicationData app) throws IOException {
        try {
            System.out.println(String.format(Text.text("updater.title"), app.updateURL));
            Resources r = Resources.getLast(app);
            boolean local = r.analyzeLocal();
            System.out.println(Text.text("updater.local.version") + " " + Text.text(local ? "updater.local.ready" : "updater.local.broken"));
            System.out.println("Downloading...");
            UpdateStatus status = r.analyzeUpdate();
            System.out.println(Text.text("updater.update.version") + " " + status.getMessage());
            if (status.isUpdateAvailable()) {
                r.updateAll(new ProcessListener(){
                    int printedDots = 0;

                    @Override
                    public void nextFile(String action) {
                        System.out.println();
                        System.out.print("Downloading " + action);
                        this.printedDots = 0;
                    }

                    @Override
                    public void knownSize(String size) {
                        System.out.print(" " + size + " ");
                    }

                    @Override
                    public void loadingPercent(int percent) {
                        int dots = percent / 4;
                        int dif = dots - this.printedDots;
                        if (dif > 0) {
                            IntStream.range(0, dif).forEach(i -> System.out.print('.'));
                            this.printedDots = dots;
                        }
                    }
                });
                System.out.println();
                System.out.println(Text.text("updater.done"));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            locker.close();
        }
    }
}

