/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.launcher;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.FileUtil;
import com.teacode.update2.common.Text;
import java.io.File;
import java.io.IOException;

public class TempWorker {
    private static final String JAR_PREFIX = "run";
    private static final String JAR_EXT = ".jar";
    protected final File tmpDir;

    public TempWorker(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    protected void cleanup() {
        File[] files = this.tmpDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (!name.startsWith(JAR_PREFIX) || !name.endsWith(JAR_EXT)) continue;
                file.delete();
            }
        }
    }

    public File createJar(File file, Long crcNeed) throws IOException {
        File ret = File.createTempFile(JAR_PREFIX, JAR_EXT, this.tmpDir);
        long crc = FileUtil.copyFileCRC(file, ret);
        if (crcNeed != null && crc == crcNeed) {
            return ret;
        }
        throw new IllegalStateException(String.format(Text.text("launcher.crc.failed"), file));
    }

    public static TempWorker create(ApplicationData app) {
        TempWorker ret = new TempWorker(app.runDir);
        ret.cleanup();
        return ret;
    }
}

