/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.common;

import com.teacode.update2.common.ApplicationData;
import com.teacode.update2.common.BusyException;
import com.teacode.update2.common.Text;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class Locker {
    private final RandomAccessFile raf;
    private final File lockFile;
    private static final String UPDATE_SUFFIX = "update";

    public Locker(ApplicationData app, boolean updater) throws NoSuchAlgorithmException, IOException {
        FileLock lock;
        File dir = app.updateDir;
        String n = "locked._";
        String lockName = "locked._" + (updater ? UPDATE_SUFFIX : Locker.generateSuffix());
        this.lockFile = new File(dir, lockName);
        this.raf = new RandomAccessFile(this.lockFile, "rws");
        try {
            lock = this.raf.getChannel().tryLock();
        }
        catch (Exception e) {
            lock = null;
        }
        if (lock == null) {
            throw new BusyException(Text.text(updater ? "locker.updater.already" : "locker.launcher.already"));
        }
        this.raf.write(("Update URI: " + app.updateURL + "\nJVM name: " + ManagementFactory.getRuntimeMXBean().getName() + "\nTimestamp: " + new Date()).getBytes(StandardCharsets.UTF_8));
        if (updater) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String s;
                    if (!file.isFile() || (s = file.getName()).equals(lockName) || !s.startsWith("locked._") || Locker.tryLockDelete(file)) continue;
                    throw new BusyException(Text.text("locker.launcher.working"));
                }
            }
        } else if (!Locker.tryLockDelete(new File(dir, "locked._update"))) {
            throw new BusyException(Text.text("locker.updater.working"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLockDelete(File file) {
        try {
            try (RandomAccessFile r = new RandomAccessFile(file, "rws");){
                FileLock lock = r.getChannel().tryLock();
                if (lock == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            file.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String generateSuffix() throws UnsupportedEncodingException {
        return URLEncoder.encode(ManagementFactory.getRuntimeMXBean().getName(), "UTF-8");
    }

    public void close() {
        try {
            this.raf.close();
            this.lockFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

