/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.common;

import com.teacode.update2.common.ui.Display;
import java.io.File;
import java.util.Arrays;

public class ApplicationData {
    public final Display display;
    public final String updateURL;
    public final File updateDir;
    public final File runDir;

    public ApplicationData(Display display, String updateURL, File updateDir, File runDir) {
        this.display = display;
        this.updateURL = updateURL;
        this.updateDir = updateDir;
        this.runDir = runDir;
    }

    public ApplicationData(Display display, String updateURL, String[] updateDir, String runDir) {
        this.display = display;
        this.updateURL = updateURL;
        this.updateDir = this.createUpdateDir(updateDir);
        this.runDir = this.createRunDir(runDir);
    }

    public ApplicationData copy(Display display) {
        return new ApplicationData(display, this.updateURL, this.updateDir, this.runDir);
    }

    public File createUpdateDir(String[] updateDir) {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new RuntimeException("user.home property is not defined");
        }
        File homeDir = new File(userHome);
        if (!homeDir.isDirectory()) {
            throw new RuntimeException("The user.home property found, but it is not a directory: " + homeDir);
        }
        File[] dir = new File[]{homeDir};
        Arrays.stream(updateDir).forEach(n -> {
            File t = new File(dir[0], (String)n);
            if (t.exists()) {
                if (!t.isDirectory()) {
                    throw new RuntimeException("Found, but it is not a directory: " + t);
                }
            } else if (!t.mkdir()) {
                throw new RuntimeException("Failed to create the directory: " + t);
            }
            dir[0] = t;
        });
        return dir[0];
    }

    public File createRunDir(String runDir) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            throw new RuntimeException("java.io.tmpdir property is not defined");
        }
        File tmp = new File(tmpDir);
        if (!tmp.isDirectory()) {
            throw new RuntimeException("Ths java.io.tmpdir property found, but it is not a directory: " + tmpDir);
        }
        String suffix = "";
        int counter = 0;
        while (true) {
            File ret = new File(tmp, runDir + suffix);
            ret.mkdirs();
            if (ret.isDirectory()) {
                return ret;
            }
            suffix = "-" + counter;
            ++counter;
        }
    }
}

