/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.updater.ui;

import com.teacode.update2.updater.ui.ActionState;
import com.teacode.update2.updater.ui.ProgressWindow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public abstract class ProgressWorker<T>
extends SwingWorker<Void, ActionState>
implements ActionListener {
    protected final ProgressWindow dia;
    protected final String title;
    protected Exception ex;
    protected T result;

    public ProgressWorker(Window parent, String title, String globalAction) {
        this.dia = new ProgressWindow(parent, title, globalAction);
        this.title = title;
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            this.result = this.doWork();
        }
        catch (Exception e) {
            this.ex = e;
        }
        return null;
    }

    public void setAction(String action, Integer percent) {
        this.publish(new ActionState(action, percent));
    }

    @Override
    protected void process(List<ActionState> actions) {
        if (!actions.isEmpty()) {
            this.dia.setAction(actions.get(actions.size() - 1));
        }
    }

    @Override
    protected void done() {
        this.dia.setVisible(false);
        this.dia.dispose();
        if (this.ex == null) {
            this.doneWork(this.result);
        } else {
            this.terminatedWork(this.ex);
        }
    }

    protected abstract T doWork() throws Exception;

    protected abstract void doneWork(T var1);

    protected abstract void terminatedWork(Exception var1);

    public void start() {
        this.execute();
        Timer timer = new Timer(100, this);
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isDone() || this.isCancelled()) {
            return;
        }
        this.dia.setVisible(true);
    }
}

