/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.updater.ui;

import com.teacode.update2.common.Text;
import com.teacode.update2.updater.ui.ActionState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressWindow
extends JDialog {
    public final JProgressBar progressBar;
    public final JLabel label;

    public ProgressWindow(Window parent, String title, String comment) {
        super(parent, title, DEFAULT_MODALITY_TYPE);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel commentLabel = new JLabel(comment);
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        panel.add((Component)commentLabel, "First");
        panel.add((Component)this.label, "Center");
        panel.add((Component)this.progressBar, "Last");
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setContentPane(panel);
        this.setDefaultCloseOperation(0);
        this.setAction(Text.text("updater.init"), null);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setAction(String currentAction, Integer percent) {
        this.label.setText(currentAction);
        if (percent == null) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString(null);
            this.progressBar.setValue(Math.max(Math.min(percent, 100), 0));
        }
    }

    public void setAction(ActionState action) {
        this.setAction(action.getAction(), action.getPercent());
    }
}

