/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.update2.launcher.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class Splasher {
    protected static SplashWindow splashWindow;
    protected static boolean eventInstalled;

    public static void showSplash(String text) {
        if (splashWindow == null) {
            splashWindow = new SplashWindow(text);
        }
        if (!eventInstalled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    WindowEvent w;
                    if (event instanceof WindowEvent && (w = (WindowEvent)event).getWindow() != splashWindow && w.getID() == 200 && splashWindow != null) {
                        splashWindow.close();
                        splashWindow = null;
                    }
                }
            }, 64L);
            eventInstalled = true;
        }
        splashWindow.setVisible(true);
    }

    static {
        eventInstalled = false;
    }

    protected static class SplashWindow
    extends JWindow {
        public SplashWindow(String text) {
            JLabel l = new JLabel(text);
            Font font = l.getFont();
            l.setFont(font.deriveFont(0, font.getSize2D() * 1.5f));
            l.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            l.setBackground(Color.WHITE);
            l.setForeground(Color.BLACK);
            this.setContentPane(l);
            this.setBackground(Color.WHITE);
            this.pack();
            this.setLocationRelativeTo(null);
        }

        public void close() {
            this.setVisible(false);
        }
    }
}

